/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game.gamelogic;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.Array;

public class NonPlayableCharacter {
    public Rectangle sprite;
    public float centreX;
    public float centreY;
    public int direction;
    public TextureRegion currentFrame;
    private float stateTime = 0.0f;
    private final Array<Animation<TextureRegion>> walkingAnimation = new Array();
    private final Array<Animation<TextureRegion>> idleAnimation = new Array();
    public int scale = 4;
    public boolean moving = false;

    public NonPlayableCharacter(String avatar, int direction) {
        this.direction = direction;
        TextureAtlas playerAtlas = new TextureAtlas(Gdx.files.internal("Sprites/Player/player_sprites.atlas"));
        this.walkingAnimation.add(new Animation<TextureAtlas.AtlasRegion>(0.25f, playerAtlas.findRegions(avatar + "_walk_back"), Animation.PlayMode.LOOP), new Animation<TextureAtlas.AtlasRegion>(0.25f, playerAtlas.findRegions(avatar + "_walk_right"), Animation.PlayMode.LOOP), new Animation<TextureAtlas.AtlasRegion>(0.25f, playerAtlas.findRegions(avatar + "_walk_front"), Animation.PlayMode.LOOP), new Animation<TextureAtlas.AtlasRegion>(0.25f, playerAtlas.findRegions(avatar + "_walk_left"), Animation.PlayMode.LOOP));
        this.idleAnimation.add(new Animation<TextureAtlas.AtlasRegion>(0.4f, playerAtlas.findRegions(avatar + "_idle_back"), Animation.PlayMode.LOOP), new Animation<TextureAtlas.AtlasRegion>(0.4f, playerAtlas.findRegions(avatar + "_idle_right"), Animation.PlayMode.LOOP), new Animation<TextureAtlas.AtlasRegion>(0.4f, playerAtlas.findRegions(avatar + "_idle_front"), Animation.PlayMode.LOOP), new Animation<TextureAtlas.AtlasRegion>(0.4f, playerAtlas.findRegions(avatar + "_idle_left"), Animation.PlayMode.LOOP));
        this.sprite = new Rectangle(0.0f, 0.0f, 17 * this.scale, 28 * this.scale);
    }

    public void updateAnimation() {
        this.stateTime += Gdx.graphics.getDeltaTime();
        this.currentFrame = this.moving ? this.walkingAnimation.get(this.direction).getKeyFrame(this.stateTime) : this.idleAnimation.get(this.direction).getKeyFrame(this.stateTime);
    }

    public void setMoving(boolean moving) {
        this.moving = moving;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public TextureRegion getCurrentFrame() {
        return this.currentFrame;
    }

    public float getX() {
        return this.sprite.getX();
    }

    public float getY() {
        return this.sprite.getY();
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public void setX(float x) {
        this.sprite.setX(x);
        this.recalculateCentre();
    }

    public void setY(float y) {
        this.sprite.setY(y);
        this.recalculateCentre();
    }

    public void setPos(float x, float y) {
        this.setX(x);
        this.setY(y);
    }

    private void recalculateCentre() {
        this.centreX = this.sprite.getX() + this.sprite.getWidth() / 2.0f;
        this.centreY = this.sprite.getY() + this.sprite.getHeight() / 2.0f;
    }
}

